#ifndef _PROCESSING_H_
#define _PROCESSING_H_

#include "common.h"

// version info
#define DATA_STRUCTURE_VERSION		5		// for checking PC-SPB-CPB compatibility
#define ALGORITHM_MAJOR_VERSION		5		// for checking PC-CPB compatibility
#define ALGORITHM_MINOR_VERSION		5		// for CPB only

#define CAPTURE_WIDTH 			640
#define CAPTURE_HEIGHT			480

#define PROCESSING_WIDTH 		640
#define PROCESSING_HEIGHT		480

#define IMAGE_3D_WIDTH 			640
#define IMAGE_3D_HEIGHT			480

#define PRINT_DATA_SIZE 20000
#define THREED_PRINT_DATA_SIZE 15000
#define THREED_SLICE_PRINT_DATA_SIZE 10000
#define THREED_PRINT_MAX_LABEL_COUNT 10


#define PRINT_LABEL_DATA_SIZE 4000
#define PRINT_EXPAND_MASKING_DATA_SIZE 2000
#define UNCOATING  1
#define FILMCOATING  2
#define SUGARCOATING  3

#define ROUND  1
#define OBLONG  2
#define OVAL  3
#define HEXA  4
#define TRIANGLE  5
#define SQUARE 6
#define ETC  10

#define STAMP 1
#define PRINT 2

#define DARK 1
#define BRIGHT 2

#define ONE_FACE 1
#define TWO_FACE_SAME 2
#define TWO_FACE_DIFF 3

#define DEFECT_COLOR_R 1                //2D      ҷ
#define DEFECT_COLOR_G 2                //2D      ҷ
#define DEFECT_COLOR_B 3                //2D      ҷ
#define DEFECT_FRONT_DIRTY 4            //2D     £ ̹
#define DEFECT_FRONT_STICKING 5         //2D     Ƽŷ
#define DEFECT_FRONT_STAIN 6            //2D     𼭸 ̿  帰 ̹
#define DEFECT_SIDE_DIRTY 7             //2D      £ ̹
#define DEFECT_SIDE_STAIN 8             //2D      帰 ̹
#define EDGE_BREAKING 9                //2D      𼭸  帰 ̹
#define DEFECT_TABLET_SIZE 10           //3D      
#define DEFECT_OPTION 11                //2D     ɼ ī޶ ҷ
#define DEFECT_PRINT_ERASE 12           //2D     μ 
#define DEFECT_PRINT_SPREAD 13            //2D     μ 
#define DEFECT_3D_BREAKING_FOR_NORMAL_AREA 14     //3D    ļ
#define DEFECT_3D_PRINT_ERASE 15                  //3D      Or ٸ 
#define DEFECT_FRONT_COLOR_DIRTY  16              //2D   ̹ Or  .
#define DEFECT_HEIGHT 17
#define DEFECT_SIDE_COLOR_DIRTY  18              //2D   ̹ Or  .
#define DEFECT_3D_BREAKING_FOR_EDGE_AREA 19     //3D   𼭸  ļ
#define DEFECT_FRONT_EDGE_DIRTY 20            // 2D  𼭸  ̹

#define UNINS_CLOSED 				256
#define UNINS_TABLET_POSITION		257
#define UNINS_BRIGHTNESS_DROPPED	258
#define UNINS_BRIGHTNESS_CHASE		259
#define THIN_TALBET					260
#define FAT_TALBET					261

#define NOT_PLATE 0
#define PLATE 1

#define THREE_D_CAMERA_ZOOM 40

#define ONECOLOR 0
#define TWOCOLOR 1
#define THREECOLOR 2

#define    FRONT_FACE_FOR_COLOR  0
#define    REAR_FACE_FOR_COLOR   1

#define    CONSTANT_ADJUST_VALUE_BY_LASER   26

#define ARRANGE 1
#define NOT_ARRANGE 0


typedef struct
{
	int IsDefectA;
	int IsDefectB;
	unsigned int EvalValue;
	short PrintIsSW;
	short ThickErrorSW;
    int Front_Rear;
} TDefectData;

typedef struct
{
	int CamMask;
    int StudyCount;
    unsigned short ShutterSpeed[4];
	unsigned short ShutterDelay[4];
	unsigned short TriggerFreq[4];
} TStudySetupData;

typedef struct
{
	int dummy;
} TStudyData_SPB;


typedef struct
{
	int DataCount;
	unsigned short ColorB[256];
	unsigned short ColorG[256];
	unsigned short ColorR[256];
	unsigned short PrintMatchingValue1[1000];
	unsigned short PrintMatchingValue2[1000];
	unsigned short ThreeDHeight1[256];
	unsigned short ThreeDHeight2[256];
	unsigned short RearColorB[256];
	unsigned short RearColorG[256];
	unsigned short RearColorR[256];
} TStudyResultData_SPB;

typedef struct
{
	int height;
	unsigned char color[3];
	char dummy;
	unsigned short print_matching_value[2];
} TStudyData_CPB;

typedef struct
{
    int CamMask;
    unsigned short ShutterSpeed[4];
    unsigned short ShutterDelay[4];
	unsigned short TriggerFreq[4];
	int MaxProcessingWaitingTime;
} TInspectData;


typedef struct
{
    unsigned char kind;
    unsigned char shape;
    unsigned char color;
    unsigned char discriminationDisplay_kind;
    int length;
    int width;
    int height;
    int middle_height;
    unsigned char discriminationDisplay_num;
    unsigned char print;
    unsigned char printColor;
    unsigned char printGrayLebelForTablet;
    unsigned char plateInformation;
    unsigned char dummy[3];

    int tabletColorN;
    int tabletLayerCount;
    int arrangeInfo;
    int symmetric_line_count;
    int dummy2[96];
}TTabletCharacter;

typedef struct
{
    short FrontShapeEdgePoint[2000][3];                             // 12,000 Byte
    short FrontShapeEdgePoint_Shrink[2000][2];                      // 8,000 Byte
    short FrontShapeEdgePoint_Expansion[2000][2];                   // 8,000 Byte
    int FrontShapeEdgePointCount;                                   // 4 Byte
    int FrontShapeEdgePointShrinkCount;                             // 4 Byte
    int FrontShapeEdgePointExpansionCount;                          // 4 Byte
    unsigned char FrontshapeAreaData[640*480];                      // 307,200 Byte
    unsigned char OpenCloseSearchArea[640*480];                     // 307,200 Byte
    short SensitiveStickingAreaData1[20][4000];                     // 160,000 Byte
    short SensitiveStickingAreaData2[20][4000];                     // 160,000 Byte
    int SensitiveStickingAreaData1Count[20];                        // 80 Byte
    int SensitiveStickingAreaData2Count[20];                        // 80 Byte
    // 962,572 Byte = 962KB

    short SensitiveStickingAreaNeighborData1[20][4000];             // 160,000 Byte
    short SensitiveStickingAreaNeighborData2[20][4000];             // 160,000 Byte
    int SensitiveStickingAreaNeighborData1Count[20];                // 80 Byte
    int SensitiveStickingAreaNeighborData2Count[20];                // 80 Byte
    // 1,282,732 = 1.2MB

    int SensitiveStickingAreaLabelN1;                               // 4 Byte
    int SensitiveStickingAreaLabelN2;                               // 4 Byte

    short position_printData1[PRINT_DATA_SIZE][2];                  // 80,000 Byte
    short expansion_position_printData1[PRINT_DATA_SIZE][2];        // 80,000 Byte
    short position_printData2[PRINT_DATA_SIZE][2];                  // 80,000 Byte
    short expansion_position_printData2[PRINT_DATA_SIZE][2];        // 80,000 Byte
    int printData1Count;                                            // 4 Byte
    int printData2Count;                                            // 4 Byte
    int expansion_printData1Count;                                  // 4 Byte
    int expansion_printData2Count;                                  // 4 Byte
    // 1,602,756 = 1.6MB

    int DiskRingStartYPositionForCamera2;                           // 4 Byte
    int DiskRingEndYPositionForCamera2;                             // 4 Byte
    int DiskRingStartYPositionForCamera7;                           // 4 Byte
    int DiskRingEndYPositionForCamera7;                             // 4 Byte

    int DiskRingStartYPositionForCamera1;                           // 4 Byte
    int DiskRingEndYPositionForCamera1;                             // 4 Byte
    int DiskRingStartYPositionForCamera6;                           // 4 Byte
    int DiskRingEndYPositionForCamera6;                             // 4 Byte


    int DiskBaseHeightPositionForCamera3;                           // 4 Byte
    int DiskBaseHeightPositionForCamera4;                           // 4 Byte
    int DiskBaseHeightPositionForCamera5;                           // 4 Byte
    int DiskBaseHeightPositionForCamera8;                           // 4 Byte
    int DiskBaseHeightPositionForCamera9;                           // 4 Byte
    int DiskBaseHeightPositionForCamera10;                          // 4 Byte

    int cameraZoom[10];                                             // 40 Byte

    int ImageCutStartX[10];                                         // 40 Byte
    int ImageCutEndX[10];                                           // 40 Byte
    int ImageCutStartY[10];                                         // 40 Byte
    int ImageCutEndY[10];                                           // 40 Byte
    // 1,603,012 = 1.6MB

    short InspectionAreaPointDataForBackLightImage[200*200][4]; //x,y,r,angle   // 320,000 Byte
    int InspectionAreaPointDataCntForBackLightImage;                // 4 Byte

    int DiskBaseHeightPositionAdjustValueForCamera3;                // 4 Byte
    int DiskBaseHeightPositionAdjustValueForCamera4;                // 4 Byte
    int DiskBaseHeightPositionAdjustValueForCamera5;                // 4 Byte

    int DiskBaseHeightPositionAdjustValueForCamera8;                // 4 Byte
    int DiskBaseHeightPositionAdjustValueForCamera9;                // 4 Byte
    int DiskBaseHeightPositionAdjustValueForCamera10;               // 4 Byte

    int PrintPositionAdjustValueForCamera1[4][2];                   // 32 Byte
    int PrintPositionAdjustValueForCamera2[4][2];                   // 32 Byte
    int PrintPositionAdjustValueForCamera6[4][2];                   // 32 Byte
    int PrintPositionAdjustValueForCamera7[4][2];                   // 32 Byte

    int protoStudyColorR;                                           // 4 Byte
    int protoStudyColorG;                                           // 4 Byte
    int protoStudyColorB;                                           // 4 Byte
    // 1,923,180 = 1.9MB


    short position_slice_printData1[PRINT_DATA_SIZE][2];            // 80,000 Byte
    short expansion_slice_position_printData1[PRINT_DATA_SIZE][2];  // 80,000 Byte
    short position_slice_printData2[PRINT_DATA_SIZE][2];            // 80,000 Byte
    short expansion_slice_position_printData2[PRINT_DATA_SIZE][2];  // 80,000 Byte
    int slice_printData1Count;                                      // 4 Byte
    int slice_printData2Count;                                      // 4 Byte
    int expansion_slice_printData1Count;                            // 4 Byte
    int expansion_slice_printData2Count;                            // 4 Byte
    // 2,243,196 = 2.2MB

    short printLabelData[2][THREED_PRINT_MAX_LABEL_COUNT][PRINT_LABEL_DATA_SIZE][2]; // DISK, FORNT/Front_reverse/REAR/Rear_reverse/ LABEL N, x/y;    // 320,000 Byte
    int printLabelDataCnt[2][THREED_PRINT_MAX_LABEL_COUNT];         // 80 Byte
    int printLabelCount[2];                                         // 8 Byte

    int rear_protoStudyColorR;                                      // 4 Byte
    int rear_protoStudyColorG;                                      // 4 Byte
    int rear_protoStudyColorB;                                      // 4 Byte
    int dummy[95];                                                  // 380 Byte
    // 2,563,676 = 2.5MB
}TTabletSetupData;


typedef struct
{
    short Disk1FrontShapeEdgePoint[2000][3];                        // 12,000 Byte
    short Disk1FrontShapeEdgePoint_Shrink[2000][2];                 // 8,000 Byte
    short Disk1FrontShapeEdgePoint_Expansion[2000][2];              // 8,000 Byte
    int Disk1FrontShapeEdgePointCount;                              // 4 Byte
    int Disk1FrontShapeEdgePointShrinkCount;                        // 4 Byte
    int Disk1FrontShapeEdgePointExpansionCount;                     // 4 Byte
//    unsigned char Disk1Frontshape3DAreaData[IMAGE_3D_WIDTH*IMAGE_3D_HEIGHT];
   // short Disk1SensitiveStickingAreaData1[20][4000];
   // short Disk1SensitiveStickingAreaData2[20][4000];
    int Disk1SensitiveStickingAreaData1Count[20];                   // 80 Byte
    int Disk1SensitiveStickingAreaData2Count[20];                   // 80 Byte

    int Disk1SensitiveStickingAreaLabelN1;                          // 4 Byte
    int Disk1SensitiveStickingAreaLabelN2;                          // 4 Byte

    short Disk1position_printData1[THREED_PRINT_DATA_SIZE][2];      // 60,000 Byte
    short Disk1position_printData2[THREED_PRINT_DATA_SIZE][2];      // 60,000 Byte
    int Disk1printData1Count;                                       // 4 Byte
    int Disk1printData2Count;                                       // 4 Byte

    short Disk1position_slice_printData1[THREED_SLICE_PRINT_DATA_SIZE][2];  // 40,000 Byte
    short Disk1position_slice_printData2[THREED_SLICE_PRINT_DATA_SIZE][2];  // 40,000 Byte
    int Disk1slice_printData1Count;                                 // 4 Byte
    int Disk1slice_printData2Count;                                 // 4 Byte
    // 228,196 = 228KB


    short Disk2FrontShapeEdgePoint[2000][3];                        // 12,000 Byte
    short Disk2FrontShapeEdgePoint_Shrink[2000][2];                 // 8,000 Byte
    short Disk2FrontShapeEdgePoint_Expansion[2000][2];              // 8,000 Byte
    int Disk2FrontShapeEdgePointCount;                              // 4 Byte
    int Disk2FrontShapeEdgePointShrinkCount;                        // 4 Byte
    int Disk2FrontShapeEdgePointExpansionCount;                     // 4 Byte
//    unsigned char Disk2Frontshape3DAreaData[IMAGE_3D_WIDTH*IMAGE_3D_HEIGHT];
   /// short Disk2SensitiveStickingAreaData1[20][4000];
 //   short Disk2SensitiveStickingAreaData2[20][4000];
    int Disk2SensitiveStickingAreaData1Count[20];                   // 80 Byte
    int Disk2SensitiveStickingAreaData2Count[20];                   // 80 Byte

    int Disk2SensitiveStickingAreaLabelN1;                          // 4 Byte
    int Disk2SensitiveStickingAreaLabelN2;                          // 4 Byte

    short Disk2position_printData1[THREED_PRINT_DATA_SIZE][2];      // 60,000 Byte
    short Disk2position_printData2[THREED_PRINT_DATA_SIZE][2];      // 60,000 Byte
    int Disk2printData1Count;                                       // 4 Byte
    int Disk2printData2Count;                                       // 4 Byte
    // 484,384 = 484KB

    short Disk2position_slice_printData1[THREED_SLICE_PRINT_DATA_SIZE][2];    // 40,000 Byte
    short Disk2position_slice_printData2[THREED_SLICE_PRINT_DATA_SIZE][2];    // 40,000 Byte
    int Disk2slice_printData1Count;                                 // 4 Byte
    int Disk2slice_printData2Count;                                 // 4 Byte
    // 456,392 = 456KB


    short printLabelData[2][2][THREED_PRINT_MAX_LABEL_COUNT][PRINT_LABEL_DATA_SIZE][2]; // DISK, FORNT/Front_reverse/REAR/Rear_reverse/ LABEL N, x/y; // 640,000 Byte
    int printLabelDataCnt[2][2][THREED_PRINT_MAX_LABEL_COUNT];      // 160 Byte
    int printLabelCount[2][2];                                      // 16 Byte

    short printLabelDataForExpandMasking[2][2][THREED_PRINT_MAX_LABEL_COUNT][PRINT_EXPAND_MASKING_DATA_SIZE][2]; // DISK, FORNT/Front_reverse/REAR/Rear_reverse/ LABEL N, x/y; // 320,000 Byte
    int printLabelDataCntForExpandMasking[2][2][THREED_PRINT_MAX_LABEL_COUNT]; // 160 Byte

    int disk1EdgeHeightDiff[30];                                    // 120 Byte
    int disk2EdgeHeightDiff[30];                                    // 120 Byte
    int dummy[9940];                                                // 39760 Byte
    // 1,456,728 = 1.5MB

}TTablet3DSetupData;


typedef struct
{
    int tabletColorR_ForCamera1;
    int tabletColorG_ForCamera1;
    int tabletColorB_ForCamera1;
    int tabletColorR_ForCamera6;
    int tabletColorG_ForCamera6;
    int tabletColorB_ForCamera6;
    int Print1_IsOrNotThreshold_ForCamrara1;
    int Print2_IsOrNotThreshold_ForCamrara1;
    int Print1_IsOrNotThreshold_ForCamrara2;
    int Print2_IsOrNotThreshold_ForCamrara2;
    int Print1_IsOrNotThreshold_ForCamrara6;
    int Print2_IsOrNotThreshold_ForCamrara6;
    int Print1_IsOrNotThreshold_ForCamrara7;
    int Print2_IsOrNotThreshold_ForCamrara7;
    int middleHeight;
    // 60 Byte

    int goodProductRatio_ForFrontStainDefect[3][20];              // 240 Byte
    int goodProductRatio_ForFrontDirtyDefect[3][20];              // 240 Byte
    int goodProductRatio_ForFrontSpecicalStickingDefect[3][20];   // 240 Byte
    int goodProductRatio_ForFrontEdgeBreakingDefect[3][20];       // 240 Byte
    int goodProductRatio_ForFrontEdgeDirtyDefect[3][20];          // 240 Byte
    // 1,260 Byte

    int height1;
    int height2;

    int tabletRearColorR_ForCamera1;
    int tabletRearColorG_ForCamera1;
    int tabletRearColorB_ForCamera1;
    int tabletRearColorR_ForCamera6;
    int tabletRearColorG_ForCamera6;
    int tabletRearColorB_ForCamera6;
    int selectedFace;
    int tabletThickForFirstDisk;
    int tabletThickForSecondDisk;
    // 1,304 Byte

    int dummy[90];
    // 360 + 1,304 = 1,664 Byte = 1.6KB
}TTabletStudyData;

typedef struct
{
    int tabletColorR_ForCamera1;
	int tabletColorG_ForCamera1;
	int tabletColorB_ForCamera1;
	int tabletColorR_ForCamera6;
	int tabletColorG_ForCamera6;
	int tabletColorB_ForCamera6;
	int Print1_IsOrNotThreshold_ForCamrara1;
	int Print2_IsOrNotThreshold_ForCamrara1;
	int Print1_IsOrNotThreshold_ForCamrara2;
	int Print2_IsOrNotThreshold_ForCamrara2;
	int Print1_IsOrNotThreshold_ForCamrara6;
	int Print2_IsOrNotThreshold_ForCamrara6;
	int Print1_IsOrNotThreshold_ForCamrara7;
	int Print2_IsOrNotThreshold_ForCamrara7;
	int middleHeight;
	int goodProductRatio_ForFrontStainDefect[3][20];
	int goodProductRatio_ForFrontDirtyDefect[3][20];
	int goodProductRatio_ForFrontSpecicalStickingDefect[3][20];
	int goodProductRatio_ForFrontEdgeBreakingDefect[3][20];
	int goodProductRatio_ForFrontEdgeDirtyDefect[3][20];

    int height1;
    int height2;
    int tabletRearColorR_ForCamera1;
    int tabletRearColorG_ForCamera1;
    int tabletRearColorB_ForCamera1;
    int tabletRearColorR_ForCamera6;
    int tabletRearColorG_ForCamera6;
    int tabletRearColorB_ForCamera6;
    int selectedFace;
    int tabletThickForFirstDisk;
    int tabletThickForSecondDisk;

    int dummy[90];
}TTabletStudyResultData;


typedef struct
{
////Front//////////
    int option_front_edgeBreaking_Intensity; // option
    int front_stain_Intensity;
    int front_stain_Size;
    int front_edge_Intensity;
    int front_edge_Size;
    int front_edge_dirty_Intensity;
    int front_edge_dirty_Size;
    int front_dirty_Intensity;
    int front_dirty_Size;
    int front_color_Intensity;
    int frontShapeEdgeNeighborRange;
    int frontBorderIsSW;
    int frontSmallSizeGrade;
////option//////////
    int option_Breaking_Intensity;   // option
    int option_PrintMark_Intensity;  // option
    int option_Breaking_Size;
////Side//////////
    int side_stain_Intensity;
    int side_stain_Size;
    int side_dirty_Intensity;
    int side_dirty_Size;
    int side_Edge_Neighbor_Intensity;
    int sideShapeEdgeMaskRange;

////////////////
    int FrontEdgeAreaExtendSW;
///////////////////

    int frontShaepEdgeSaturationEraseSW;
    int front_print_dirty_Inetensity;
    int option_front_edgeBreaking_Size; // option
    int front_print_erase_Intensity;
    int front_print_spread_Intensity;

    int front_Color_Dirty_Intensity;
    int front_Color_Dirty_Size;
//////////////////////////////////////////////////////
    int front_unInspectionIntensity_ForPrint;
    int front_unInspectionIntensity_ForEdge;
    int front_unInspectionIntensity_ForOptionPrint;
    int front_unInspectionIntensity_ForOptionEdge;

    int rear_stain_Intensity;
    int rear_stain_Size;
    int rear_edge_Intensity;
    int rear_edge_Size;
    int rear_edge_dirty_Intensity;
    int rear_edge_dirty_Size;
    int rear_dirty_Intensity;
    int rear_dirty_Size;
    int rear_print_dirty_Inetensity;
    int rear_Color_Dirty_Intensity;
    int rear_Color_Dirty_Size;

    int side_height_Intensity;
    int side_Color_Dirty_Intensity;
    int side_Color_Dirty_Size;
    int threeDEdgeAreaExtend;
    int threeD_Height_Plus_Limit;
    int threeD_Height_Minus_Limit;
    int Saturation_Erase_SW;
    int dummy[96];

}TTabletGradeData;


typedef struct
{
    int defectSeries;
    int cameraIndex;
    int defectPositionStartX;
    int defectPositionEndX;
    int defectPositionStartY;
    int defectPositionEndY;
    int size;
    int dummy[10];
}TDefectInformation;

typedef struct
{
	int TabletNumber;
	int GlobalCameraIndex;
	TDefectInformation CPBDefectInfo;
} TDefectData_SPB;


typedef struct
{
	int TabletNumber;
	int GlobalCameraIndex;
	int CameraInspectPosition;
	int dummy[4];
	TDefectInformation CPBDefectInfo;
} TDefectData_PC;



#ifdef __cplusplus
extern "C"
{
#endif  /* __cplusplus */

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif

